/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GlowingSlimeBlock
extends SlimeBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public GlowingSlimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (stack.is(Items.GLOW_INK_SAC)) {
            if (!((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
                blockState = (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
                level.setBlock(blockPos, blockState, 3);
                level.updateNeighborsAt(blockPos, (Block)this);
                level.levelEvent(player, 3003, blockPos, 0);
                stack.consume(1, (LivingEntity)player);
                return ItemInteractionResult.SUCCESS;
            }
        } else if (stack.is(ItemTags.AXES) && ((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            blockState = (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
            level.setBlock(blockPos, blockState, 3);
            level.updateNeighborsAt(blockPos, (Block)this);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }
}

